From: steffen@mbcr.bcm.tmc.edu (David Steffen)
Newsgroups: bionet.general
Subject: A Cynic Looks at a MOO
Message-ID: <1kc240INNkp7@gazette.bcm.tmc.edu>
Date: 29 Jan 93 19:55:44 GMT
Organization: Baylor College of Medicine, Houston, Tx
Lines: 365

************************************************************************
			  EXECUTIVE SUMMARY

Recently, Rob Harper posted a description of a great new concept in
computer communication - something called a MOO.  It was about a year
and a half ago when Rob introduced us to another new technology; WAIS.
When I reviewed WAIS back then, I found a system of considerable
promise still a little ragged around the edges. In the case of the
MOO, I have found a concept of enormous promise which, again, is not
quite developed enough to be useful.  However, like, WAIS, development
on the MOO concept is proceeding rapidly and although the average,
working biologist will probably not derive full benefit from this
system yet, it is time for all interested biologists to begin
experimenting with MOOs, so that we can guide its development into
the most useful form.  In my opinion, those of you in the business of
providing computer resources to fellow biologists definitely want to
learn about this concept as soon as possible.
************************************************************************

Disclaimer: Everything in this article is my opinion only; Baylor
College of Medicine has nothing to do with any of it.  I am not an
expert on MOOs; this is a user's review.  If this review makes you mad
enough to flame, flame yourself.  If you flame me and as a result I do
something rash, my wife and kids will sue you.

============================== INTRODUCTION ============================

  More years ago than I like to remember, David Kristofferson
poineered the introduction of the USENET technology to biologists
under the name of BIONET.  At the time he began this effort, the
newsgroup technology was mature, having been developed and polished by
the computer science community.  Over the years, David has succeeded
in introducing a significant subset of the biological research
community to this technology and thus has provided a new means of
communication between biologists.  Although BIONET doesn't correspond
exactly to any traditional (non-computer) mode of communication, one
can think of it like a journal consisting entirely of letters to the
editor - it is timely but asyncronous (e.g. people read and post
information at times convenient to themselves without regard to the
times that other users posted the message to which they might be
responding or which others will read their message.)  and is
disseminated to a large list of subscribers in the same way that a
journal is.  The obvious contrast is to email, which corresponds
fairly closely to mail or to FAX which are also asyncronous forms of
communication, but ones which normally occur between only two users.
(Electronic mailing lists are more like USENET than they are like
email, of course.)

  About a year and a half ago, Rob Harper introduced us to an emerging
new technology - WAIS.  If BIONET is like a journal, then WAIS servers
are like libraries, which maintain archives of data.  (Consistent with
this metaphor is the fact that the back issues of the Bionet "journal"
are available in a "WAIS" library.)  A year and a half ago, I argued
that the WAIS concept was not quite ready for the average biologist.
Things have changed rapidly since then.  Many more WAIS databases have
appeared, making WAIS access no longer an indulgence, but practically
a necessity.  In addition, WAIS clients have been installed in many
institutions (including on the Molecular Biology Computing Resource
computer at my home institution of Baylor) making the use WAIS not a
test of ones computer prowess, but rather an easy task for the
computer indifferent biologist.  Further, a new standard has appeared;
the "gopher", and has similarly become widespread and readily
available.  Like WAIS, gopher provides access to "libraries" of data
on the NET.  One of the powers of gopher is its flexibility; it is now
possible to access both native gopher databases as well as WAIS
databases through the same gopher client.

  A couple of weeks ago, Rob Harper again alerted us to a new
development in computer communication; something called a MOO.  MOO is
not a bovine vocalization but yet another development in informatics.
If Bionet is a Journal, and WAIS and gopher are libraries, then a MOO
is an electronic version of a scientific meeting.  Like WAIS a year
and a half ago, the MOOs are not quite ready for working biologists.
Like WAIS, MOO development is progressing rapidly and soon will
represent another powerful tool for scientific communication.

  [A measure of how rapidly things are developing is that this
represents version 2 of this review, version 1 having been overtaken by
events before having seen the light of day.]

============================ WHAT IS A MOO? ============================

  First, a confession.  A MOO is a game, descendant of a long line of
games.  Our current interest in the MOO is as a tool for scientific
communication, but if this bastard lineage is too distressing to your
puritanical soul, read no further!

  The acronym MOO stands for MUD, Object Oriented, with MUD being
itself and acronym for Multi User Dungeon.  A MOO is a text only game
in which players move around an imaginary environment, described to
them in words, by issuing commands such as "go north" "take sword" or
"examine scroll".  Because it is multi-user, you can interact with
other people using the same dungeon.  It is the possibility of
interpersonal interaction which makes the MUD concept such a powerful
force for good.  The MOO concept adds the capability of easy
customizability, greatly facilitating the conversion of a game into a
scientific communication tool.

1) Why should biologists care about a bovine-sounding computer game?

  Athough the MUD/MOO environment was created for games, a number of
computer scientists have noticed that the same human interaction that
made them so attractive as games could be harnessed for work.
Furthermore, the customizability of the MOO lends itself to the
modification of the game environment for practical ends.  When such
modifications are worked out, MOOs promise to provide yet another
efficient, low cost way for scientific communication.  MOOs could
replace scientific meetings!

2) What happened to make the MOO environment of interest NOW?

  The computer science community has been interested in MOOs as a
serious tool for some time.  If you read Rob Harpers original message,
he describes hearing serious computer scientists talking about this at
meetings.  What got those of us biologists who are now interested
involved was Rob's post.  I cannot speak for Rob, but it is my
impression that it was the introduction of gopher servers into one
particular MOO, JaysHouseMOO, that got Rob involved.  Given the
immense popularity of gopher for biological information retrieval
combined the long standing interest of the computer science community
in MOOs, the urge to explore this technology could no longer be
resisted.

3) What advantages does a MOO have over other gopher servers?

  For the lone scientist using gopher to retrieve information, there
are *NO* advantages to using a MOO - it just adds another layer on top
of the gopher server, degrading performance and reliability.
Furthermore, the MOO environment requires that the command syntax be
different for a gopher in a MOO environment compared to a traditional
gopher client, leading to confusion.  After experimenting with
JaysHouseMoo for but a few days, however, I have already noticed one
advantage to the gopher in the MOO environment; it is an excellent
environment in which an experienced gopher user can show a novice the
ropes.

  I must admit, however, that despite the fact that the integrated
gopher server was the device which seduced biologists into MOOs, I do
not personally consider them the most important part of the MOO.  I
believe is the real time multi-person interaction which will turn out
to be what makes MOOs useful.  One of David Kristofferson's chronic
frustrations with Bionet is the paucity of "real scientific
discussions" which occur here.  Even in my limited experience on
Jay's MOO, it is clear to me that this "conversation" environment is
more conducive to such discussions than is the "journal" environment
of Bionet.  After all, aren't the discussions you have at meetings
more free wheeling and frank than what you read in journals?

==================== I'M GOING FOR IT; ANY TIPS? ===================

FIRST: The MOO we are using, JaysHouseMOO, belongs to Jay.  We are
guests in his "house" and we should act like guests.  This means being
very sensitive to any requests the primary users and developers of
this MOO make of us.  Furthermore, we should try to learn and abide by
the conventions of the MOO.  Compared to USENET, a MOO is a very
polite place; friendly greetings are expected and flames unheard of.

  We are setting up a "Biosciences Electronic Conference Center" (ECC
for short) in one part of this MOO.  Jay has asked us to more or less
restrict our modification of his MOO to this part of his MOO, although
we are welcome to explore the rest of the MOO.  Mark Adams, a graduate
student at Baylor College of Medicine, and Rob Harper, have been the
prime players so far in setting up this ECC.

SECOND: Don't expect too much - we are still working on this.  With
luck, you will run into some fellow biologists and have some
interesting conversations.  At worst, you will learn about how a MOO
works and get in some practice.  I suspect that real action will
require some advanced scheduling, but we are all learning about this
together.

  For the MOO to become really useful, we are going to have to start
organizing meetings there.  As a 'test of concept' and to identify
areas that need work, Mark Adams and I will be organizing a
meta-meeting on the topic of "Use of MOOs in Biology".  Stay tuned to
Bionet for further details.  In the mean time, send me email if you
would like to 'attend' this 'meeting', register yourself as a
character on the MOO, and become a little familiar with how it works
(see below for instructions).  As we start having meetings, we will
identify aspects of the MOO that need to be modified.  At present, we
are at least thinking about implementation of white boards, how poster
sessions could be accomplished, the implementation of a graphics
protocols so that talks and posters could include figures.

INSTRUCTIONS:

  In order to use the MOO, you must have TELNET access to Internet.
(There are better hosts than TELNET for accessing the MOO, but
they require the same facilities as TELNET.)  To access the MOO, you
have to TELNET to an address AND a port.  The command is typed as
follows:

telnet theory.cs.mankato.msus.edu 1709

  If you omit the port number (1709), you will connect to the right
computer, but not to the MOO, and will be unable to log on.

  You will be greeted with a full screen logon message (quoted in Rob's
description) which gives you a bunch of helpful hints.  Initially, you
want to log on as "guest", and to do so you type the command as
follows:

connect guest

  Success is greeted by a description of the first "room" of the
"dungeon".  There may or may not be people or objects in the room.  If
there are, they will be mentioned after the description, one line per
person or object.  For example:

rMark is here
Be aware, however, that people listed as 'here' might not actually be
logged in.  If they don't respond, that is probably why.  Rob, for
example, spends lots of time sleeping, unresponsive, in his office.

BASIC COMMANDS:

(Note, many commands begin with the "at" symbol, @.  This is a 
necessary part of the command.)

@quit - to log off when you are finished.  You can do this any time,
any where.  However, if you have been 'conversing' with people, it is
polite to type the usual good byes.

help - gets you LOTS more information about the dungeon.  This 
is the best way to learn about the dungeon.

" - beginning a line with a quote sends a message to everyone 
in the room with you.  If you type:

"Hello!

what happens is that everyone in the room will see the 
message:

Guest says "Hello!"

======================== From MOO to bioMOO ========================

(enough with the games, lets get to work!):

  To get to the ECC, issue the following commands, each terminated by
a carriage return.

u
w
w
s
s
s

  This should get you to the 'lobby' of the ECC.  If not, just wander
around until you find it.  It is at the south end of the woods, just west
of the highway.

  Now would be a good time to see who else is around, and where they
are.  Issue the command:

@who

and you will see a display like:

Player name       Connected    Idle time    Location
-----------       ---------    ---------    --------
Steffen (#774)    an hour      0 seconds    Woods Clearing Biosciences Center L
Moedonna (#512)   an hour      3 minutes    BiosciencesECC Library
Larry (#76)       24 minutes   4 minutes    BiosciencesECC Library

(Characters who are not logged on will not show up.  This is one good
way to distinguish the zombies from the living.)

If you were in the Lobby, you would see me (Steffen).  I am a sociable
sort, so I probably already would have buttonholed you.

  To talk to someone else, you need to go where they are.  Because
there is no good map of the MOO, and because the topology of parts of
the MOO can change, this can be more of a game than we would like.
Right now, the ECC has 6 rooms.  From the Lobby, you go upstairs to
the Reception Area.  To the west of the Reception Area is the Student
Advisory Office (aka Rob Harper's Office) and to the east is the
Faculty Lounge (a sick joke of rMark's -more about that later.)  To
the South of the lobby is the quadrangle, and to the south of that the
is Library.  In the above example, going to the library will allow you
to talk to Moedonna and Larry.  Also, in the library is where we try
to keep to gopher servers (when they haven't been stolen!)  This is a
a good place as any to experiment with use of gophers in the MOO
environment.  (There are several other gopher servers in the MOO.)

======================= I'm hooked; what now? =======================

  The MOO environment is exceptionally flexible.  To maximize its
usefulness, we are creating some guidelines for MOOing biologists.
All of these are just suggestions, of course; we are just trying to
figure out conventions to maximize usefulness.

FIRST: Stop with the Guest stuff; make yourself a character.
This is an opportunity to identify yourself.  When people use a MOO as
a game, they create fanciful, imaginary characters for themselves.  We
suggest you create a character who people can identify as you.  We
think this will facilitate scientific communication.  I am "Steffen".
Rob Harper is "Rob".  "rMark" is R. Mark Adams, a Grad Student at
Baylor.  That way, when I see Rob, I know who he is, he knows who I
am, and we can quickly initiate a useful conversation.  You create a
character as follows; suppose your name is David Kristofferson, and
you email address is kristoff@genbank.bio.net, you would type:

@register Kristofferson for kristoff@genbank.bio.net

You will be sent email with your password.  Thus, the above will only
be useful to you if you ARE Dave Kristofferson.

The next time you log on, you type:

connect Kristofferson <whateverpasswordyouwereassigned>

Next, you need to give yourself a description.  I am trying to get
everyone to include one of those dopy plastic name tags in their
descriptions.  For example, my description is as follows:

Middle aged, balding, and friendly looking.  He is wearing a plastic name tag:
David Steffen, Associate Professor of Cell Biology, Baylor College of Medicine,
Houston TX.  Interests: Retroviruses, Oncogenes, Gene Therapy

You would see this description by typing:

look Steffen

That way, you would know who I am and what I do, and thus, if I am
someone you would like to talk to.

Once you have logged in as your character, you give yourself a
description by typing:

@describe me as <place a short description here.  Mine is as long as
is allowed.  Terminate the description with a carriage return.  To
force line breaks, you have to insert spaces -ug!>

Finally, if you want to go right to the ECC every time you log in, go
to the Faculty Lounge and type:

@sethome

If this doesn't work, try again later.  We are still working on this.

The Sick Joke:  Once you create a character, you stay in the MOO even
when you are not logged in.  Most people have as their 'home' the
underground hole under the highway.  That room has been programmed so
that 'sleeping' people (e.g. characters not logged in) are invisible.
rMark and I decided it would be useful to keep 'sleeping' biologists
visible, so that others could see the list of participants.  To keep
the confusion down, we decided to make an out of the way room in which
people could sleep.  I suggested the dormitory.  rMark made it the
Faculty Lounge.  I think rMark is going to find his next Thesis
Advisory Committee Meeting difficult.

As you play with with MOO, note what you like and what you don't like.
Send complements, suggestions, questions, or money to:

steffen@bcm.tmc.edu

See you at the MOO!
-- 
David Steffen
Department of Cell Biology, Baylor College of Medicine, Houston TX 77030
Telephone = (713) 798-6655, FAX = (713) 790-0545
Internet = steffen@bcm.tmc.edu
